/*
 * 	DCM.c
 *DCM.o: DCM.c
	@ echo ".compilin"
	 $(CC) $(CFLAGS) DCM.c
 *  Created on: Aug 23, 2010
 *  Author: Jared Rought
 *
 *  Function: Provides the directional cosine matrix for self-stabilization calculations.
 */

#define T  1/(1.09803921*(float)237 + 20.0)
#define KPXY 0.0001
#define KIXY 0.0000005
#define KPZ 0.5
#define KIZ 0.0005

//Global DCM Variables
float Gyro[3] = {0,0,0};
float Accel[3] = {0,0,0};
float Magno[3] = {0,0,0};
float Omega[3];
float OmegaI[3] = {0, 0, 0};
float OmegaP[3] = {0, 0, 0};
float ErrorXY[3] = {0,0,0};
float ErrorZ[3] = {0,0,0};


//Base Rotational Matrix
float Rmat[3][3] = {
		{1,0,0},
		{0,1,0},
		{0,0,1}
};

//This function updates the rotational matrix based on the measured gyro values,
//Then subsequently normalizes the matrix to compensate for accumulated numerical
//integration errors.
void updateRmat(float Omega[3]){

	RmatUpdated[0][0] = 1;
	RmatUpdated[0][1] = Omega[2]*T;  //z
	RmatUpdated[0][2] = -Omega[1]*T; //-y
	RmatUpdated[1][0] = -Omega[2]*T; //-z
	RmatUpdated[1][1] = 1;
	RmatUpdated[1][2] = Omega[0]*t; //x
	RmatUpdated[2][0] = Omega[1]*t; //y
	RmatUpdated[2][1] = -Omega[0]*t;//-x
	RmatUpdated[2][2] = 1;

	matrixMult(&RmatTemp, &Rmat, &RmatUpdated);
	matrixAdd(&Rmat, &Rmat, &RmatTemp);

	normRmat(&Rmat);

}

//DCM normalizing function
void normRmat(void){
	float error;
	float normalized;
	float Xorthog[3] = {0, 0, 0};
	float Yorthog[3] = {0, 0, 0};
	float Zorthog[3] = {0, 0, 0};

						//X vector  //Y vector
	error = -vectorDot(&Rmat[0][0], &Rmat[1][0])*0.5; //error scaling factor

	//X orthogonal vector
	vectorScale(&Xorthog, &Xorthog, &error);
	vectorAdd(&Xorthog, &Xorthog, &Rmat[0][0]);

	//Y orthogonal vector
	vectorScale(&Yorthog, &Yorthog, &error);
	vectorAdd(&Xorthog, &Xorthog, &Rmat[1][0]);

	//Z orthogonal vector
	vectorCross(&Zorthog, &Xorthog, &Yorthog);

	//Taylor's Expansion
	//X normalized
	normalized = 0.5*(3-vectorDot(&Xorthog, &Xorthog));
	vectorScale(&Rmat[0][0], &Xorthog, &normalized);

	//Y normalized
	normalized = 0.5*(3-vectorDot(&Yorthog, &Yorthog));
	vectorScale(&Rmat[0][0], &Yorthog, &normalized);

	//Z normalized
	normalized = 0.5*(3-vectorDot(&Zorthog, &Zorthog));
	vectorScale(&Rmat[0][0], &Zorthog, &normalized);
}

//Gyro drift compensation function. This function compensates for pitch, roll and yaw drift
void correctRmat(void){

	//Roll and Pitch Correction
	vectorCross(&ErrorXY, &Rmat[2][0], &Accel[0]);

	//Yaw Correction
	//Magnetometer heading calculation
	COGX = Magno[0] / Magnitude;
	COGY = Magno[1] / Magnitude;

	YawCorrectionGround = Rmat[0][0]*COGX - Rmat[1][0]*COGY;
	vectorScale(YawCorrectionPlane, Rmat[2], YawCorrectionGround);
	YawCorrectionPlane = ErrorZ;

}

//PI loop function for utilizing the error that was calculated by the drift compensation function
void PILoop(float){
	float OmegaITemp[0] = {0,0,0};


	vectorScale(&OmegaP[0], &ErrorXY[0], &KPXY);
	vectorScale(&OmegaITmp[0], &ErrorXY[0], &KIXY);
	vectorAdd(&OmegaI[0], &OmegaI[0], &OmegaITmp[0]);

	//Yaw Correction
	vectorScale(&OmegaP[0], &ErrorZ[0], &KPZ);
	vectorScale(&ErrorXYScaled[0], &ErrorXY, &KPXY);
	vectorAdd(&OmegaP[0], &OmegaP[0], &ErrorXYScaled);

	vectorScale(&OmegaITmp[0], &ErrorZ[0], &KIZ);
	vectorScale(&ErrorXYScaled[0], &ErrorXY, &KIXY);
	vectorAdd(&OmegaI[0], &OmegaI[0], &ErrorXYScaled);

	vectorAdd(&OmegaI[0], &OmegaI[0], &OmegaITmp[0]);
}

//DCM arithmatic

//Matrix operations
void matrixMult(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]){
	float MatTemp[3];
	int i, j, k;

	for(i=0;i<3;i++){
		for(j=0;i<3;j++){
			for(k=0;k<3;k++){
				MatTemp[k] = Mat1[j][k]*Mat2[j][k];
			}
			MatOut[i][j] = MatTemp[1] + MatTemp[2]+ MatTemp[3];
		}
	}
}

void matrixAdd(float MatOut[3][3], float Mat1[3][3], float [3][3]){
	int i,j;

	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			MatOut[i][j] = Mat1[i][j] + Mat2[i][j];
		}
	}
}

void vectorCross(float CrossOut[3], float v1[3], float v2[3]){
	CrossOut[0] = (v1[1]*v2[2]) - (v1[2]*v2[1]);
	CrossOut[1] = (v1[2]*v2[0]) - (v1[0]*v2[2]);
	CrossOut[2] = (v1[0]*v2[1]) - (v1[1]*v2[0]);
}

//Vector Operations
float vectorDot(float v1[3], float v2[3]){
	int i;
	float dot;

	for(i=0;i<3;i++){
		dot += v1[i]*v2[i];
	}return dot;
}

void vectorAdd(float vOut[3], float v1[3], float v2[3]){
	int i;

	for(i=0;i<3;i++){
		vOut[i] = v1[i] + v2[i];
	}
}

void vectorScale(float vOut[3], float vIn[3], ScaleFactor){
	int i;

	for(i=0;i<3;i++){
		vOut[i] = vIn[i]*ScaleFactor;
	}
}
